# Checklist CSS untuk Web Hosting

## ✅ Perbaikan yang Sudah Dilakukan

### 1. Path Relatif
- ✅ Semua path gambar menggunakan quotes: `url('../images/file.png')`
- ✅ Path relatif dari `theme/css/style.css` ke `theme/images/` sudah benar
- ✅ Tidak ada hardcoded absolute path

### 2. Vendor Prefixes
- ✅ Semua gradient memiliki `-webkit-`, `-moz-`, `-o-` prefixes
- ✅ Semua transform memiliki vendor prefixes
- ✅ Backdrop filter memiliki `-webkit-backdrop-filter` prefix
- ✅ Box-sizing memiliki vendor prefixes

### 3. Fallback untuk Browser Lama
- ✅ Background gradient memiliki fallback warna solid
- ✅ Modern CSS features memiliki fallback

### 4. Kompatibilitas
- ✅ CSS Variables dengan fallback
- ✅ Smooth scroll dengan fallback
- ✅ Modern animations dengan fallback

## 📋 Checklist Upload ke Hosting

### File yang Harus Diupload

```
theme/
├── css/
│   ├── style.css ✅ (File utama - sudah diperbaiki)
│   ├── bootstrap.min.css
│   ├── font-awesome.min.css
│   ├── simple-line-icons.css
│   ├── slick.css
│   ├── slick-theme.css
│   └── owl.carousel.min.css
├── images/
│   ├── chart_bg.png ✅
│   ├── about-bg.jpg ✅
│   ├── discription-icon.png ✅
│   ├── right-icon.png ✅
│   ├── shortcode-list.png ✅
│   ├── coming-soon-img.jpg ✅
│   └── [semua file gambar lainnya]
└── fonts/
    └── [semua file font]
```

### Verifikasi Setelah Upload

1. **Cek File CSS**
   - Buka: `https://yourdomain.com/theme/css/style.css`
   - Pastikan file bisa diakses dan tidak error 404

2. **Cek File Gambar**
   - Buka: `https://yourdomain.com/theme/images/chart_bg.png`
   - Pastikan semua gambar bisa diakses

3. **Cek di Browser**
   - Buka website
   - Tekan F12 > Console
   - Cek apakah ada error loading CSS atau gambar
   - Cek tab Network untuk file yang gagal load

## 🔧 Konfigurasi CodeIgniter

### File: `application/config/config.php`

**Untuk Development (Local):**
```php
$config['base_url'] = 'http://localhost/websitesekolah/';
```

**Untuk Production (Hosting):**
```php
// Opsi 1: Set manual
$config['base_url'] = 'https://yourdomain.com/';

// Opsi 2: Auto-detect (tidak disarankan untuk production)
$config['base_url'] = '';
```

## 🐛 Troubleshooting

### Masalah: CSS tidak ter-load
**Solusi:**
1. Cek path di browser: `https://yourdomain.com/theme/css/style.css`
2. Pastikan file permissions: `chmod 644 style.css`
3. Cek `.htaccess` tidak memblokir file CSS

### Masalah: Gambar tidak muncul
**Solusi:**
1. Cek path relatif dari `theme/css/style.css` ke `theme/images/`
2. Pastikan struktur folder sama
3. Cek case sensitivity (Linux case-sensitive)

### Masalah: Efek blur tidak muncul
**Solusi:**
- Normal untuk browser lama
- Backdrop filter hanya support di browser modern
- Website tetap berfungsi, hanya efek blur yang tidak muncul

### Masalah: Gradient tidak muncul
**Solusi:**
- Browser lama akan menggunakan warna solid sebagai fallback
- Pastikan fallback color sudah didefinisikan

## 📝 Catatan Penting

1. **Path Relatif vs Absolute**
   - CSS menggunakan path relatif: `../images/file.png`
   - Path ini relatif terhadap lokasi file CSS
   - Dari `theme/css/style.css` → `../images/` = `theme/images/`

2. **Struktur Folder Harus Sama**
   ```
   theme/
   ├── css/     (folder CSS)
   └── images/  (folder gambar - satu level di atas css/)
   ```

3. **Case Sensitivity**
   - Linux hosting case-sensitive
   - `Image.png` ≠ `image.png`
   - Pastikan nama file sesuai

4. **File Permissions**
   - CSS files: `644` (readable)
   - Images: `644` (readable)
   - Folders: `755` (executable)

## ✅ Testing Checklist

- [ ] CSS file bisa diakses via browser
- [ ] Semua gambar muncul dengan benar
- [ ] Tidak ada error di Console (F12)
- [ ] Tidak ada 404 error di Network tab
- [ ] Website tampil dengan benar
- [ ] Efek hover bekerja
- [ ] Animasi berjalan smooth
- [ ] Responsive di mobile

## 🌐 Browser Support

| Browser | Version | Support |
|---------|---------|---------|
| Chrome | 90+ | ✅ Full |
| Firefox | 88+ | ✅ Full |
| Safari | 14+ | ✅ Full |
| Edge | 90+ | ✅ Full |
| IE 11 | - | ⚠️ Partial (fallback) |
| Opera | 76+ | ✅ Full |

## 📞 Support

Jika masih ada masalah setelah upload:
1. Cek error di browser Console (F12)
2. Cek Network tab untuk file yang gagal load
3. Pastikan struktur folder sama dengan dokumentasi
4. Pastikan file permissions sudah benar
