# Panduan Deployment ke Web Hosting

## Struktur Folder yang Diperlukan

Pastikan struktur folder berikut ada di web hosting:

```
websitesekolah/
├── application/
│   ├── views/
│   │   └── depan/
│   └── ...
├── assets/
├── system/
├── theme/
│   ├── css/
│   │   └── style.css (file utama)
│   ├── images/
│   │   ├── chart_bg.png
│   │   ├── about-bg.jpg
│   │   ├── discription-icon.png
│   │   ├── right-icon.png
│   │   ├── shortcode-list.png
│   │   └── coming-soon-img.jpg
│   ├── fonts/
│   └── js/
├── index.php
└── ...
```

## Path Relatif di CSS

File `theme/css/style.css` menggunakan path relatif ke folder `theme/images/`:
- `url('../images/chart_bg.png')` - dari `theme/css/` ke `theme/images/`
- Pastikan struktur folder `theme/css/` dan `theme/images/` tetap sama

## Kompatibilitas Browser

CSS sudah ditambahkan vendor prefixes untuk:
- `-webkit-` (Chrome, Safari, Opera)
- `-moz-` (Firefox)
- `-o-` (Opera lama)
- Standard properties

## Fitur CSS Modern yang Digunakan

1. **CSS Variables** (`:root`) - Didukung di browser modern
2. **Backdrop Filter** - Dengan fallback untuk browser lama
3. **Gradient** - Dengan vendor prefixes
4. **Transform & Transition** - Dengan vendor prefixes
5. **Flexbox & Grid** - Standard CSS

## Checklist Sebelum Upload

- [ ] Pastikan semua file di folder `theme/images/` sudah diupload
- [ ] Pastikan struktur folder `theme/css/` dan `theme/images/` sama seperti di local
- [ ] Pastikan file `style.css` sudah diupload ke `theme/css/`
- [ ] Pastikan semua font di `theme/fonts/` sudah diupload
- [ ] Test di browser berbeda setelah upload

## Troubleshooting

### CSS tidak muncul
1. Cek path file CSS di browser (F12 > Network)
2. Pastikan `base_url()` di CodeIgniter sudah benar
3. Cek file permissions (harus readable)

### Gambar tidak muncul
1. Cek path relatif `../images/` dari `theme/css/style.css`
2. Pastikan file gambar ada di `theme/images/`
3. Cek case sensitivity (Linux hosting case-sensitive)

### Efek blur tidak muncul
- Backdrop filter memerlukan browser modern
- Fallback: background tetap terlihat, hanya efek blur yang tidak muncul

### Gradient tidak muncul
- Browser lama mungkin tidak support
- Fallback: warna solid akan digunakan

## Testing Setelah Upload

1. Buka website di browser
2. Tekan F12 untuk Developer Tools
3. Cek tab Console untuk error
4. Cek tab Network untuk file yang gagal load
5. Test di beberapa browser:
   - Chrome (latest)
   - Firefox (latest)
   - Safari (latest)
   - Edge (latest)

## Catatan Penting

- **Path relatif** di CSS mengacu pada struktur folder, bukan URL
- Pastikan struktur folder sama antara local dan hosting
- CodeIgniter `base_url()` harus dikonfigurasi dengan benar di `application/config/config.php`

## Konfigurasi CodeIgniter

Pastikan di `application/config/config.php`:
```php
$config['base_url'] = 'https://yourdomain.com/';
```

Atau gunakan auto-detection:
```php
$config['base_url'] = '';
```

## Support Browser

- Chrome 90+
- Firefox 88+
- Safari 14+
- Edge 90+
- Opera 76+

Browser lama akan tetap berfungsi dengan fallback yang tersedia.
