# 🚀 Panduan Upload Website ke Hosting

## ⚡ Quick Start

### 1. Upload Semua File
Upload seluruh folder dan file ke hosting dengan struktur yang sama:
```
websitesekolah/
├── application/
├── assets/
├── system/
├── theme/          ← PENTING: Pastikan folder ini lengkap
│   ├── css/
│   ├── images/
│   ├── fonts/
│   └── js/
├── index.php
└── .htaccess
```

### 2. Konfigurasi CodeIgniter
Edit file `application/config/config.php`:
```php
$config['base_url'] = 'https://yourdomain.com/';
```

### 3. Cek File CSS
Buka di browser: `https://yourdomain.com/theme/css/style.css`
- Harus bisa diakses
- Tidak boleh error 404

### 4. Test Website
Buka website dan tekan **F12** untuk cek error.

## ✅ Yang Sudah Diperbaiki

1. ✅ **Path relatif** - Semua path gambar sudah benar
2. ✅ **Vendor prefixes** - Kompatibel dengan semua browser
3. ✅ **Fallback** - Browser lama tetap berfungsi
4. ✅ **.htaccess** - Tidak memblokir file CSS/JS/gambar

## 📁 File Penting yang Harus Diupload

### CSS Files
- `theme/css/style.css` ← **FILE UTAMA**
- `theme/css/bootstrap.min.css`
- `theme/css/font-awesome.min.css`
- `theme/css/slick.css`
- `theme/css/owl.carousel.min.css`

### Images (di `theme/images/`)
- `chart_bg.png`
- `about-bg.jpg`
- `discription-icon.png`
- `right-icon.png`
- `shortcode-list.png`
- `coming-soon-img.jpg`
- Dan semua gambar lainnya

### Fonts (di `theme/fonts/`)
- Semua file font (.woff, .woff2, .ttf, .eot)

## 🔍 Troubleshooting

### CSS tidak muncul?
1. Cek: `https://yourdomain.com/theme/css/style.css`
2. Pastikan file ada di hosting
3. Cek permissions (harus readable)

### Gambar tidak muncul?
1. Pastikan folder `theme/images/` sudah diupload
2. Cek path relatif dari CSS ke images
3. Cek case sensitivity (Linux case-sensitive)

### Error 404?
1. Cek struktur folder sama dengan local
2. Cek `.htaccess` sudah diupload
3. Cek `base_url` di config.php

## 📞 Butuh Bantuan?

Lihat file lengkap:
- `DEPLOYMENT_GUIDE.md` - Panduan detail
- `CSS_HOSTING_CHECKLIST.md` - Checklist lengkap

## ⚠️ Catatan Penting

1. **Struktur folder harus sama** antara local dan hosting
2. **Case sensitivity** - Linux hosting case-sensitive
3. **File permissions** - CSS: 644, Folder: 755
4. **base_url** - Harus diset dengan benar di config.php

---

**Status:** ✅ CSS sudah siap untuk web hosting!
